typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;

#ifdef _MSC_VER
typedef unsigned __int64 u64;
#else
typedef unsigned long long u64;
#endif

typedef signed char s8;
typedef signed short s16;
typedef signed int s32;

#ifdef _MSC_VER
typedef signed __int64 s64;
#else
typedef signed long long s64;
#endif

/*void Scanlines(u8 *srcPtr, u32 srcPitch, u8 *,
			   u8 *dstPtr, u32 dstPitch, int width, int height)
{
	__asm {
		mov			eax, width;
		mov			edx, srcPitch;
		shr			eax, 2;
		shl			eax, 3;
		sub			edx, eax;
		mov			srcPitch, edx;
		shr			eax, 3;
		mov			width, eax;
		mov			esi, srcPtr;
		mov			edi, dstPtr;
		mov			edx, edi;
		add			edx, dstPitch;
		mov			ecx, height;
		pxor		mm2, mm2;
		align 4;
label0:
		mov			eax, width;
		align 4;
label1:
		movq		mm0, qword ptr [esi];
		movq		mm1, mm0;
		punpcklwd	mm0, qword ptr [esi];
		punpckhwd	mm1, qword ptr [esi];
		movq		qword ptr [edi], mm0;
		movq		qword ptr [edx], mm2;
		movq		qword ptr [edi + 8], mm1;
		movq		qword ptr [edx + 8], mm2;

		add			esi, 8;
		add			edi, 16;
		add			edx, 16;
		dec			eax;
		jnz			label1;

		add			esi, srcPitch;
		add			edi, dstPitch;
		add			edx, dstPitch;

		dec			ecx;
		jnz			label0;

		;emms;
	}
}*/

#define RGB_LOW_BITS_MASK 0x0821

__int64 colorMask = ~((__int64)RGB_LOW_BITS_MASK |
					 ((__int64)RGB_LOW_BITS_MASK << 16) |
					 ((__int64)RGB_LOW_BITS_MASK << 32) |
					 ((__int64)RGB_LOW_BITS_MASK << 48));

void ScanlinesTV(u8 *srcPtr, u32 srcPitch, u8 * /* deltaPtr */,
				 u8 *dstPtr, u32 dstPitch, int width, int height)
{
	__asm {
		mov			esi, srcPtr;
		mov			edi, dstPtr;
		mov			edx, edi;
		add			edx, dstPitch;
		mov			ecx, height;
		movq		mm7, colorMask;

		;fix tiger heli and others
		mov         ebx,srcPitch;
		shl         ebx,1;
		mov         eax,dstPitch;
		sub         eax,ebx;
		add         dstPitch,eax;

		mov			eax, width;              
		mov			ebx, srcPitch;
		shl			eax, 1;                //width *2
		sub			ebx, eax;              // srcpitch - width*2
		mov			srcPitch, ebx;          
		shr			eax, 3;                 // width /4
		mov			width, eax;
		
		align 4;
label2:
		mov			eax, width;
		mov			ebx, dword ptr[esi];
		align 4;
label3:
		movq		mm0, qword ptr [esi];
		movq		mm1, mm0;
		movq		mm2, mm0;
		psllq		mm1, 16;
		pand		mm2, mm7;
		pinsrw		mm1, ebx, 0;
		psrlw		mm2, 1;
		pand		mm1, mm7;
		pextrw		ebx, mm0, 3;
		psrlw		mm1, 1;
		paddw		mm1, mm2;
		movq		mm0, mm1;
		punpckhwd	mm1, qword ptr [esi];
		punpcklwd	mm0, qword ptr [esi];
		movq		mm3, mm1;
		movq		mm2, mm0;
		pand		mm3, mm7;
		pand		mm2, mm7;
		psrlw		mm3, 1;
		psrlw		mm2, 1;
		movq		mm5, mm3;
		movq		mm4, mm2;
		pand		mm5, mm7;
		pand		mm4, mm7;
		psrlw		mm5, 1;
		psrlw		mm4, 1;
		paddw		mm3, mm5;
		paddw		mm2, mm4;

		movq qword ptr [edi], mm0;
		movq qword ptr [edx], mm2;
		movq qword ptr [edi + 8], mm1;
		movq qword ptr [edx + 8], mm3;

		add esi, 8;
		add edi, 16;
		add edx, 16;
		dec eax;
		jnz label3;

		add esi, srcPitch;
		add edi, dstPitch;
		add edx, dstPitch;

		dec ecx;
		jnz label2;

		;emms;
	}
}
